<?php
class ModelBlogBlog extends Model {
	public function addCategory($data) {

		$this->db->query("INSERT INTO " . DB_PREFIX . "newsblog_category SET name = '" . $this->db->escape($data['name']) . "', sort_order = '" . $this->db->escape($data['sort_order']) . "', status = '" . (int)$data['status'] . "'");

		$category_id = $this->db->getLastId();
		
		$this->cache->delete('newsblog_category');

		return $category_id;
	}

	public function addCategoryToList($article_list_id, $articleIds = array()) {
        if($articleIds){
	        foreach($articleIds as $articleId) {
	            $sql = "INSERT INTO " . DB_PREFIX . "newsblog_category_list SET category_id = '". (int) $article_list_id . "', article_id = '" . (int) $articleId . "'";

	            $this->db->query($sql);
	        }
    	}
        $this->cache->delete('newsblog_category_list');

        return;
    }

	public function editCategory($category_id, $data = array()) {

		$sql = "UPDATE " . DB_PREFIX . "newsblog_category SET name = '" . $this->db->escape($data['name']) . "', sort_order = '" . $this->db->escape($data['sort_order']) . "', status = '" . (int) $data['status'] . "' WHERE category_id = '" . (int) $category_id . "'";

        $this->db->query($sql);

     //    $this->db->query("DELETE FROM " . DB_PREFIX . "newsblog_category_list WHERE category_id = '" . (int)$category_id . "'");
        
     //    if($data['article']){
	    //     foreach($data['article'] as $articleId) {
	    //         $sql = "INSERT INTO " . DB_PREFIX . "newsblog_category_list SET category_id = '". (int) $category_id . "', article_id = '" . (int) $articleId . "'";

	    //         $this->db->query($sql);
	    //     }
	    // }

        $this->cache->delete('newsblog_category');

        return;

		// $this->db->query("UPDATE " . DB_PREFIX . "newsblog_category SET parent_id = '" . (int)$data['parent_id'] . "', sort_order = '" . (int)$data['sort_order'] . "', status = '" . (int)$data['status'] . "', date_modified = NOW(), `settings` = '" . $this->db->escape($settings) . "' WHERE category_id = '" . (int)$category_id . "'");

		// if (isset($data['image'])) {
		// 	$this->db->query("UPDATE " . DB_PREFIX . "newsblog_category SET image = '" . $this->db->escape($data['image']) . "' WHERE category_id = '" . (int)$category_id . "'");
		// }

		// $this->db->query("DELETE FROM " . DB_PREFIX . "newsblog_category_description WHERE category_id = '" . (int)$category_id . "'");

		// foreach ($data['category_description'] as $language_id => $value) {
		// 	$this->db->query("INSERT INTO " . DB_PREFIX . "newsblog_category_description SET category_id = '" . (int)$category_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "', description = '" . $this->db->escape($value['description']) . "', meta_title = '" . $this->db->escape($value['meta_title']) . "', meta_h1 = '" . $this->db->escape($value['meta_h1']) . "', meta_description = '" . $this->db->escape($value['meta_description']) . "', meta_keyword = '" . $this->db->escape($value['meta_keyword']) . "'");
		// }

		// // MySQL Hierarchical Data Closure Table Pattern
		// $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "newsblog_category_path` WHERE path_id = '" . (int)$category_id . "' ORDER BY level ASC");

		// if ($query->rows) {
		// 	foreach ($query->rows as $category_path) {
		// 		// Delete the path below the current one
		// 		$this->db->query("DELETE FROM `" . DB_PREFIX . "newsblog_category_path` WHERE category_id = '" . (int)$category_path['category_id'] . "' AND level < '" . (int)$category_path['level'] . "'");

		// 		$path = array();

		// 		// Get the nodes new parents
		// 		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "newsblog_category_path` WHERE category_id = '" . (int)$data['parent_id'] . "' ORDER BY level ASC");

		// 		foreach ($query->rows as $result) {
		// 			$path[] = $result['path_id'];
		// 		}

		// 		// Get whats left of the nodes current path
		// 		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "newsblog_category_path` WHERE category_id = '" . (int)$category_path['category_id'] . "' ORDER BY level ASC");

		// 		foreach ($query->rows as $result) {
		// 			$path[] = $result['path_id'];
		// 		}

		// 		// Combine the paths with a new level
		// 		$level = 0;

		// 		foreach ($path as $path_id) {
		// 			$this->db->query("REPLACE INTO `" . DB_PREFIX . "newsblog_category_path` SET category_id = '" . (int)$category_path['category_id'] . "', `path_id` = '" . (int)$path_id . "', level = '" . (int)$level . "'");

		// 			$level++;
		// 		}
		// 	}
		// } else {
		// 	// Delete the path below the current one
		// 	$this->db->query("DELETE FROM `" . DB_PREFIX . "newsblog_category_path` WHERE category_id = '" . (int)$category_id . "'");

		// 	// Fix for records with no paths
		// 	$level = 0;

		// 	$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "newsblog_category_path` WHERE category_id = '" . (int)$data['parent_id'] . "' ORDER BY level ASC");

		// 	foreach ($query->rows as $result) {
		// 		$this->db->query("INSERT INTO `" . DB_PREFIX . "newsblog_category_path` SET category_id = '" . (int)$category_id . "', `path_id` = '" . (int)$result['path_id'] . "', level = '" . (int)$level . "'");

		// 		$level++;
		// 	}

		// 	$this->db->query("REPLACE INTO `" . DB_PREFIX . "newsblog_category_path` SET category_id = '" . (int)$category_id . "', `path_id` = '" . (int)$category_id . "', level = '" . (int)$level . "'");
		// }

		// $this->db->query("DELETE FROM " . DB_PREFIX . "newsblog_category_to_store WHERE category_id = '" . (int)$category_id . "'");

		// if (isset($data['category_store'])) {
		// 	foreach ($data['category_store'] as $store_id) {
		// 		$this->db->query("INSERT INTO " . DB_PREFIX . "newsblog_category_to_store SET category_id = '" . (int)$category_id . "', store_id = '" . (int)$store_id . "'");
		// 	}
		// }

		// $this->db->query("DELETE FROM " . DB_PREFIX . "newsblog_category_to_layout WHERE category_id = '" . (int)$category_id . "'");

		// if (isset($data['category_layout'])) {
		// 	foreach ($data['category_layout'] as $store_id => $layout_id) {
		// 		$this->db->query("INSERT INTO " . DB_PREFIX . "newsblog_category_to_layout SET category_id = '" . (int)$category_id . "', store_id = '" . (int)$store_id . "', layout_id = '" . (int)$layout_id . "'");
		// 	}
		// }

		// $this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'newsblog_category_id=" . (int)$category_id . "'");

		// if ($data['keyword']) {
		// 	$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'newsblog_category_id=" . (int)$category_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		// }

		//$this->cache->delete('category');

	}

	public function deleteCategory($category_id) {

		$this->db->query("DELETE FROM " . DB_PREFIX . "newsblog_category_path WHERE category_id = '" . (int)$category_id . "'");

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_category_path WHERE path_id = '" . (int)$category_id . "'");

		foreach ($query->rows as $result) {
			$this->deleteCategory($result['category_id']);
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "newsblog_category WHERE category_id = '" . (int)$category_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "newsblog_category_description WHERE category_id = '" . (int)$category_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "newsblog_category_to_store WHERE category_id = '" . (int)$category_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "newsblog_category_to_layout WHERE category_id = '" . (int)$category_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "newsblog_article_to_category WHERE category_id = '" . (int)$category_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'newsblog_category_id=" . (int)$category_id . "'");

		$this->cache->delete('category');

	}

	public function repairCategories($parent_id = 0) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_category WHERE parent_id = '" . (int)$parent_id . "'");

		foreach ($query->rows as $category) {
			// Delete the path below the current one
			$this->db->query("DELETE FROM `" . DB_PREFIX . "newsblog_category_path` WHERE category_id = '" . (int)$category['category_id'] . "'");

			// Fix for records with no paths
			$level = 0;

			$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "newsblog_category_path` WHERE category_id = '" . (int)$parent_id . "' ORDER BY level ASC");

			foreach ($query->rows as $result) {
				$this->db->query("INSERT INTO `" . DB_PREFIX . "newsblog_category_path` SET category_id = '" . (int)$category['category_id'] . "', `path_id` = '" . (int)$result['path_id'] . "', level = '" . (int)$level . "'");

				$level++;
			}

			$this->db->query("REPLACE INTO `" . DB_PREFIX . "newsblog_category_path` SET category_id = '" . (int)$category['category_id'] . "', `path_id` = '" . (int)$category['category_id'] . "', level = '" . (int)$level . "'");

			$this->repairCategories($category['category_id']);
		}
	}

	public function getCategory($category_id) {
		// $query = $this->db->query("SELECT DISTINCT *,
		// (SELECT GROUP_CONCAT(cd1.name ORDER BY level SEPARATOR '&nbsp;&nbsp;&gt;&nbsp;&nbsp;') FROM " . DB_PREFIX . "newsblog_category_path cp LEFT JOIN " . DB_PREFIX . "newsblog_category_description cd1 ON (cp.path_id = cd1.category_id AND cp.category_id != cp.path_id) WHERE cp.category_id = c.category_id AND cd1.language_id = '" . (int)$this->config->get('config_language_id') . "' GROUP BY cp.category_id) AS path,
		// (SELECT DISTINCT keyword FROM " . DB_PREFIX . "url_alias WHERE query = 'newsblog_category_id=" . (int)$category_id . "') AS keyword

		// FROM " . DB_PREFIX . "newsblog_category c
		// LEFT JOIN " . DB_PREFIX . "newsblog_category_description cd2 ON (c.category_id = cd2.category_id)

		// WHERE c.category_id = '" . (int)$category_id . "' AND
		// cd2.language_id = '" . (int)$this->config->get('config_language_id') . "'");

		// return $query->row;

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_category WHERE category_id = '" . (int)$category_id . "'");

        return $query->row;
	}

	public function getCategoryToList($category_id) {
        $query = $this->db->query("SELECT article_id FROM " . DB_PREFIX . "newsblog_category_list WHERE category_id = '" . (int)$category_id . "'");

        return $query->rows;
    }

	public function getCategoriesByParentId($parent_id = 0) {
		$query = $this->db->query("SELECT *, (SELECT COUNT(parent_id) FROM " . DB_PREFIX . "newsblog_category WHERE parent_id = c.category_id) AS children FROM " . DB_PREFIX . "newsblog_category c LEFT JOIN " . DB_PREFIX . "newsblog_category_description cd ON (c.category_id = cd.category_id) WHERE c.parent_id = '" . (int)$parent_id . "' AND cd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY c.sort_order, cd.name");

		return $query->rows;
	}

	public function getCategories($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "newsblog_category";

		$sort_data = array(
			'product_count',
			'name',
			'sort_order',
			'status'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY name";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getCategoryDescriptions($category_id) {
		$category_description_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_category_description WHERE category_id = '" . (int)$category_id . "'");

		foreach ($query->rows as $result) {
			$category_description_data[$result['language_id']] = array(
				'name'             => $result['name'],
				'meta_title'       => $result['meta_title'],
				'meta_h1'          => $result['meta_h1'],
				'meta_description' => $result['meta_description'],
				'meta_keyword'     => $result['meta_keyword'],
				'description'      => $result['description']
			);
		}

		return $category_description_data;
	}

	public function getCategoryStores($category_id) {
		$category_store_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_category_to_store WHERE category_id = '" . (int)$category_id . "'");

		foreach ($query->rows as $result) {
			$category_store_data[] = $result['store_id'];
		}

		return $category_store_data;
	}

	public function getCategoryLayouts($category_id) {
		$category_layout_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_category_to_layout WHERE category_id = '" . (int)$category_id . "'");

		foreach ($query->rows as $result) {
			$category_layout_data[$result['store_id']] = $result['layout_id'];
		}

		return $category_layout_data;
	}

	public function getTotalCategories() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "newsblog_category");

		return $query->row['total'];
	}

	public function getAllCategories() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "newsblog_category c LEFT JOIN " . DB_PREFIX . "newsblog_category_description cd ON (c.category_id = cd.category_id) LEFT JOIN " . DB_PREFIX . "newsblog_category_to_store c2s ON (c.category_id = c2s.category_id) WHERE cd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND c2s.store_id = '" . (int)$this->config->get('config_store_id') . "'  ORDER BY c.parent_id, c.sort_order, cd.name");

		$category_data = array();
		foreach ($query->rows as $row) {
			$category_data[$row['parent_id']][$row['category_id']] = $row;
		}

		return $category_data;
	}

	public function getTotalCategoriesByLayoutId($layout_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "newsblog_category_to_layout WHERE layout_id = '" . (int)$layout_id . "'");

		return $query->row['total'];
	}

	public function updateDateBase() {

		$this->db->query("ALTER TABLE `" . DB_PREFIX . "newsblog_article` CHANGE `date_available` `date_available` DATETIME NOT NULL DEFAULT '0000-00-00'");


		$query = $this->db->query("show columns FROM " . DB_PREFIX . "newsblog_category WHERE Field = 'settings'");
		if (empty($query->row['Field']))
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "newsblog_category` ADD `settings` TEXT NOT NULL");

		$query = $this->db->query("show columns FROM " . DB_PREFIX . "newsblog_article_related WHERE Field = 'type'");
		if (empty($query->row['Field']))
		$this->db->query("ALTER TABLE `" . DB_PREFIX . "newsblog_article_related` ADD  `type` INT( 1 ) NOT NULL");
	}
}
